
///////////////////////////////////////////////////////////////////////////////
//
//   ROCKWELL SEMICONDUCTOR SYSTEMS - COMMERCIAL GPS BUSINESS
//
///////////////////////////////////////////////////////////////////////////////
//
//
//   MSG1075.C - Message 1075 Processing
// 
//
//   DESCRIPTION
//
//   Functions to decode, build, and display Zodiac 1075 messages.
//
//
//   REVISION HISTORY
//
//
////////////////////////////////////////////////////////////////////////////////

#include <stdio.h>
#include <share.h>
#include <string.h>

#include "gentypes.h"
#include "gencons.h"
#include "ztypes.h"
#include "zcons.h"   
#include "util.h" 
#include "display.h"

////////////////////////////////////////////////////////////////////////////////
//   
//   Decode a Zodiac 1075 message from the ZMsgBuf.
//
void Dec1075(tMSGBUF *ZMsgBuf, tMSG1075 *Msg)
{                                            
;
}                                      
                                     
////////////////////////////////////////////////////////////////////////////////
//   
//   Build a Zodiac 1075 message in the ZMsgBuf. 
//
void Bld1075(tMSGBUF *ZMsgBuf, tMSG1075 *Msg)
{
;
}                                            

////////////////////////////////////////////////////////////////////////////////
//   
//   Display a Zodiac 1075 message from the ZMsgBuf.
//
void Show1075(tMSG1075 *Msg)
{
   char    Buf[80] = "";
   char    TestStatus[3];        

   // dr validity flags  
   strcpy(TestStatus, "   ");

   if(Msg->DRFactoryTestResultFlag & 1) TestStatus[0] = 't';
   else  TestStatus[0] = 'T';

   if(Msg->DRFactoryTestResultFlag & 8) TestStatus[1] = 'S';
   else  TestStatus[1] = 'B';
   
   // output the data items   
   sprintf(Buf,"%05d",Msg->SequenceNumber );ShowText(Buf,TIMR+ 6,TIMC+ 4);
   sprintf(Buf,"%3s",TestStatus);ShowText(Buf,DRSR+ 2,DRSC+ 6);
}                                                   
                                      
                                           
